<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar se o usuário está logado (remetente)
if (!isset($_SESSION['user_id'])) {
    $_SESSION['mensagem'] = 'Erro: Você precisa estar logado para realizar uma transação.';
    header('Location: ../dashboard.php');
    exit;
}

// Verificar se os dados do formulário foram enviados
if (isset($_POST['destinatario'], $_POST['valor'], $_POST['pin'])) {
    $destinatario = $_POST['destinatario'];
    $remetente = $_SESSION['user_wallet'];
    $dataehora = date('Y-m-d H:i:s');
    $valor = (float) $_POST['valor'];
    $pin = $_SESSION['user_pin'];
    $postpin = $_POST['pin'];
    
    // Verificar se o destinatário é igual ao remetente
    if ($destinatario === $remetente) {
        $_SESSION['mensagem'] = 'Erro: Não pode enviar para sua própria carteira.';
        header('Location: ../dashboard.php');
        exit;
    }

    // Verificar se o valor é válido
    if ($valor <= 0) {
        $_SESSION['mensagem'] = 'Erro: Valor deve ser maior que zero.';
        header('Location: ../dashboard.php');
        exit;
    }

    // Verificar saldo disponível
    if ($valor > $_SESSION['saldolivre']) {
        $_SESSION['mensagem'] = 'Erro: Saldo insuficiente.';
        header('Location: ../dashboard.php');
        exit;
    }

    // Verificar PIN
    if (!password_verify($postpin, $pin)) {
        $_SESSION['mensagem'] = 'Erro: PIN incorreto.';
        header('Location: ../dashboard.php');
        exit;
    }

    try {
        require_once 'conexao.php';
        
        // Verificar se destinatário existe
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM usersblock WHERE wallet = :destinatario");
        $stmt->bindParam(':destinatario', $destinatario);
        $stmt->execute();

        if ($stmt->fetchColumn() > 0) {
            $hash = sha1($destinatario . $remetente . $dataehora . $valor . uniqid());
            $link = bin2hex(random_bytes(25)); // Método mais seguro para gerar o link

            $stmt = $pdo->prepare("INSERT INTO mempool (destinatario, remetente, dataehora, valor, hash, link) 
                                 VALUES (:destinatario, :remetente, :dataehora, :valor, :hash, :link)");
            
            $stmt->execute([
                ':destinatario' => $destinatario,
                ':remetente' => $remetente,
                ':dataehora' => $dataehora,
                ':valor' => $valor,
                ':hash' => $hash,
                ':link' => $link
            ]);

            $_SESSION['mensagem'] = 'Transação realizada com sucesso!';
            $_SESSION['linkhash'] = $link;
        } else {
            $_SESSION['mensagem'] = 'Erro: Carteira do destinatário não encontrada.';
        }
    } catch (PDOException $e) {
        $_SESSION['mensagem'] = 'Erro no banco de dados: ' . $e->getMessage();
    }
} else {
    $_SESSION['mensagem'] = 'Erro: Todos os campos são obrigatórios.';
}

header('Location: ../dashboard.php');
exit;
?>